<?php defined('SYSPATH') or die('No direct script access.');

class Task_Autoclear_Problem extends Minion_Task
{

    protected function _execute(array $params)
    {
        $oldProblems = DB::select('id')
            ->from(ORM::factory('Problem')->table_name())
            ->where('created_at', '<', DB::expr("NOW() - INTERVAL '1 MONTH'"))
            ->limit(100);
        
        while(true) {
            $affectedRows = DB::delete(ORM::factory('Problem')->table_name())
                ->where('id', 'IN', $oldProblems)
                ->execute();
            
            if ( ! $affectedRows) {
                break;
            }
        };

        sleep(5 * Date::MINUTE);
    }

}
